/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.collections.List;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentKeyListener;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.FocusTraversalDirection;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.ListButton;
import org.apache.pivot.wtk.ListButtonListener;
import org.apache.pivot.wtk.ListButtonSelectionListener;
import org.apache.pivot.wtk.ListView;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.skin.ButtonSkin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListButtonSkin
extends ButtonSkin
implements ListButton.Skin,
ListButtonListener,
ListButtonSelectionListener {
    protected ListView listView;
    protected Window listViewPopup;
    private ComponentMouseButtonListener listViewPopupMouseButtonListener = new ComponentMouseButtonListener.Adapter(){

        public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
            ListButton listButton = (ListButton)ListButtonSkin.this.getComponent();
            ListButtonSkin.this.listViewPopup.close();
            int index = ListButtonSkin.this.listView.getSelectedIndex();
            listButton.setSelectedIndex(index);
            if (listButton.isRepeatable()) {
                listButton.press();
            }
            return true;
        }
    };
    private ComponentKeyListener listViewPopupKeyListener = new ComponentKeyListener.Adapter(){

        public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
            ListButton listButton = (ListButton)ListButtonSkin.this.getComponent();
            switch (keyCode) {
                case 10: {
                    ListButtonSkin.this.listViewPopup.close();
                    int index = ListButtonSkin.this.listView.getSelectedIndex();
                    listButton.setSelectedIndex(index);
                    if (!listButton.isRepeatable()) break;
                    listButton.press();
                    break;
                }
                case 9: {
                    ListButtonSkin.this.listViewPopup.close();
                    int index = ListButtonSkin.this.listView.getSelectedIndex();
                    listButton.setSelectedIndex(index);
                    FocusTraversalDirection direction = Keyboard.isPressed(Keyboard.Modifier.SHIFT) ? FocusTraversalDirection.BACKWARD : FocusTraversalDirection.FORWARD;
                    listButton.transferFocus(direction);
                    break;
                }
                case 27: {
                    ListButtonSkin.this.listViewPopup.close();
                }
            }
            return false;
        }
    };
    private WindowStateListener listViewPopupWindowStateListener = new WindowStateListener(){

        public void windowOpened(Window window) {
            Display display = window.getDisplay();
            display.getContainerMouseListeners().add((Object)ListButtonSkin.this.displayMouseListener);
            window.requestFocus();
        }

        public Vote previewWindowClose(Window window) {
            if (window.containsFocus()) {
                ListButtonSkin.this.getComponent().requestFocus();
            }
            return Vote.APPROVE;
        }

        public void windowCloseVetoed(Window window, Vote reason) {
            if (reason == Vote.DENY) {
                window.requestFocus();
            }
        }

        public void windowClosed(Window window, Display display, Window owner) {
            display.getContainerMouseListeners().remove((Object)ListButtonSkin.this.displayMouseListener);
            Window componentWindow = ListButtonSkin.this.getComponent().getWindow();
            if (componentWindow != null && !componentWindow.isClosing()) {
                componentWindow.moveToFront();
            }
        }
    };
    private ContainerMouseListener displayMouseListener = new ContainerMouseListener.Adapter(){

        public boolean mouseDown(Container container, Mouse.Button button, int x, int y) {
            Display display = (Display)container;
            Component descendant = display.getDescendantAt(x, y);
            if (!ListButtonSkin.this.listViewPopup.isAncestor(descendant) && descendant != ListButtonSkin.this.getComponent()) {
                ListButtonSkin.this.listViewPopup.close();
            }
            return false;
        }

        public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
            boolean consumed = false;
            Display display = (Display)container;
            Window window = (Window)display.getComponentAt(x, y);
            if (window != ListButtonSkin.this.listViewPopup) {
                consumed = true;
            }
            return consumed;
        }
    };
    protected boolean pressed = false;

    public ListButtonSkin() {
        this.listView = new ListView();
        this.listViewPopup = new Window();
        this.listViewPopup.getComponentMouseButtonListeners().add((Object)this.listViewPopupMouseButtonListener);
        this.listViewPopup.getComponentKeyListeners().add((Object)this.listViewPopupKeyListener);
        this.listViewPopup.getWindowStateListeners().add((Object)this.listViewPopupWindowStateListener);
    }

    @Override
    public void install(Component component) {
        super.install(component);
        ListButton listButton = (ListButton)component;
        listButton.getListButtonListeners().add((Object)this);
        listButton.getListButtonSelectionListeners().add((Object)this);
        this.listView.setListData(listButton.getListData());
        this.listView.setItemRenderer(listButton.getItemRenderer());
    }

    @Override
    public Window getListViewPopup() {
        return this.listViewPopup;
    }

    public abstract Bounds getTriggerBounds();

    @Override
    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        if (!component.isEnabled()) {
            this.pressed = false;
        }
        this.repaintComponent();
        this.listViewPopup.close();
    }

    @Override
    public void focusedChanged(Component component, Component obverseComponent) {
        super.focusedChanged(component, obverseComponent);
        this.repaintComponent();
        if (!component.isFocused()) {
            this.pressed = false;
            if (!this.listViewPopup.containsFocus()) {
                this.listViewPopup.close();
            }
        }
    }

    @Override
    public void mouseOut(Component component) {
        super.mouseOut(component);
        this.pressed = false;
        this.repaintComponent();
    }

    @Override
    public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseDown(component, button, x, y);
        this.pressed = true;
        this.repaintComponent();
        ListButton listButton = (ListButton)component;
        if (this.listViewPopup.isOpen()) {
            this.listViewPopup.close();
        } else if (listButton.isRepeatable() && !this.getTriggerBounds().contains(x, y)) {
            listButton.requestFocus();
        } else {
            this.listViewPopup.open(component.getWindow());
        }
        return consumed;
    }

    @Override
    public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
        this.pressed = false;
        this.repaintComponent();
        return super.mouseUp(component, button, x, y);
    }

    @Override
    public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
        boolean consumed = super.mouseClick(component, button, x, y, count);
        ListButton listButton = (ListButton)this.getComponent();
        if (listButton.isRepeatable() && !this.getTriggerBounds().contains(x, y)) {
            listButton.press();
        }
        return consumed;
    }

    @Override
    public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = false;
        ListButton listButton = (ListButton)this.getComponent();
        if (keyCode == 32) {
            this.pressed = true;
            this.repaintComponent();
            if (this.listViewPopup.isOpen()) {
                this.listViewPopup.close();
            } else if (!listButton.isRepeatable()) {
                this.listViewPopup.open(component.getWindow());
            }
        } else if (keyCode == 38) {
            int index = listButton.getSelectedIndex();
            while (--index >= 0 && listButton.isItemDisabled(index)) {
            }
            if (index >= 0) {
                listButton.setSelectedIndex(index);
                consumed = true;
            }
        } else if (keyCode == 40) {
            if (Keyboard.isPressed(Keyboard.Modifier.ALT)) {
                this.listViewPopup.open(component.getWindow());
                consumed = true;
            } else {
                int index = listButton.getSelectedIndex();
                int count = listButton.getListData().getLength();
                while (++index < count && this.listView.isItemDisabled(index)) {
                }
                if (index < count) {
                    listButton.setSelectedIndex(index);
                    consumed = true;
                }
            }
        } else {
            consumed = super.keyPressed(component, keyCode, keyLocation);
        }
        return consumed;
    }

    @Override
    public boolean keyReleased(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = false;
        ListButton listButton = (ListButton)this.getComponent();
        if (keyCode == 32) {
            this.pressed = false;
            this.repaintComponent();
            if (listButton.isRepeatable()) {
                listButton.press();
            }
        } else {
            consumed = super.keyReleased(component, keyCode, keyLocation);
        }
        return consumed;
    }

    @Override
    public boolean keyTyped(Component component, char character) {
        boolean consumed = super.keyTyped(component, character);
        ListButton listButton = (ListButton)this.getComponent();
        List<?> listData = listButton.getListData();
        ListView.ItemRenderer itemRenderer = listButton.getItemRenderer();
        character = Character.toUpperCase(character);
        int n = listData.getLength();
        for (int i = listButton.getSelectedIndex() + 1; i < n; ++i) {
            char first;
            String string;
            if (listButton.isItemDisabled(i) || (string = itemRenderer.toString(listData.get(i))) == null || string.length() <= 0 || (first = Character.toUpperCase(string.charAt(0))) != character) continue;
            listButton.setSelectedIndex(i);
            consumed = true;
            break;
        }
        return consumed;
    }

    @Override
    public void listDataChanged(ListButton listButton, List<?> previousListData) {
        this.listView.setListData(listButton.getListData());
        this.invalidateComponent();
    }

    @Override
    public void itemRendererChanged(ListButton listButton, ListView.ItemRenderer previousItemRenderer) {
        this.listView.setItemRenderer(listButton.getItemRenderer());
    }

    @Override
    public void repeatableChanged(ListButton listButton) {
    }

    @Override
    public void disabledItemFilterChanged(ListButton listButton, Filter<?> previousDisabledItemFilter) {
        this.listView.setDisabledItemFilter(listButton.getDisabledItemFilter());
    }

    @Override
    public void listSizeChanged(ListButton listButton, int previousListSize) {
    }

    @Override
    public void selectedIndexChanged(ListButton listButton, int previousSelectedIndex) {
        int selectedIndex = listButton.getSelectedIndex();
        if (selectedIndex != previousSelectedIndex) {
            Object buttonData = selectedIndex == -1 ? null : listButton.getListData().get(selectedIndex);
            listButton.setButtonData(buttonData);
            this.listView.setSelectedIndex(selectedIndex);
        }
    }

    @Override
    public void selectedItemChanged(ListButton listButton, Object previousSelectedItem) {
    }
}

