/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Menu;
import org.apache.pivot.wtk.MenuPopup;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.skin.ButtonSkin;

public abstract class MenuItemSkin
extends ButtonSkin
implements Menu.ItemListener {
    protected MenuPopup menuPopup = new MenuPopup();
    private WindowStateListener menuPopupWindowStateListener = new WindowStateListener.Adapter(){

        public void windowOpened(Window window) {
            Display display = window.getDisplay();
            display.getContainerMouseListeners().add((Object)MenuItemSkin.this.displayMouseListener);
        }

        public void windowClosed(Window window, Display display, Window owner) {
            display.getContainerMouseListeners().remove((Object)MenuItemSkin.this.displayMouseListener);
        }
    };
    private ContainerMouseListener displayMouseListener = new ContainerMouseListener.Adapter(){

        public boolean mouseDown(Container container, Mouse.Button button, int x, int y) {
            Display display = (Display)container;
            Component descendant = display.getDescendantAt(x, y);
            if (!MenuItemSkin.this.menuPopup.isAncestor(descendant) && descendant != MenuItemSkin.this.getComponent()) {
                MenuItemSkin.this.menuPopup.close();
            }
            return false;
        }
    };
    protected int buttonPressInterval = 200;
    protected ApplicationContext.ScheduledCallback buttonPressCallback = null;

    public MenuItemSkin() {
        this.menuPopup.getWindowStateListeners().add((Object)this.menuPopupWindowStateListener);
    }

    public void install(Component component) {
        super.install(component);
        Menu.Item menuItem = (Menu.Item)component;
        menuItem.getItemListeners().add((Object)this);
        this.menuPopup.setMenu(menuItem.getMenu());
    }

    public boolean isFocusable() {
        return false;
    }

    public void mouseOver(Component component) {
        super.mouseOver(component);
        final Menu.Item menuItem = (Menu.Item)this.getComponent();
        menuItem.setActive(true);
        if (this.buttonPressCallback != null) {
            this.buttonPressCallback.cancel();
            this.buttonPressCallback = null;
        }
        if (menuItem.getMenu() != null) {
            this.buttonPressCallback = ApplicationContext.scheduleCallback(new Runnable(){

                public void run() {
                    menuItem.press();
                }
            }, this.buttonPressInterval);
        }
    }

    public void mouseOut(Component component) {
        super.mouseOut(component);
        if (this.buttonPressCallback != null) {
            this.buttonPressCallback.cancel();
            this.buttonPressCallback = null;
        }
        if (!this.menuPopup.isOpen()) {
            Menu.Item menuItem = (Menu.Item)this.getComponent();
            menuItem.setActive(false);
        }
    }

    public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseDown(component, button, x, y);
        if (this.buttonPressCallback != null) {
            this.buttonPressCallback.cancel();
            this.buttonPressCallback = null;
        }
        return consumed;
    }

    public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseDown(component, button, x, y);
        Menu.Item menuItem = (Menu.Item)this.getComponent();
        if (menuItem.isActive()) {
            menuItem.press();
        }
        return consumed;
    }

    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.menuPopup.close(true);
    }

    public void buttonPressed(Button button) {
        Menu.Item menuItem = (Menu.Item)this.getComponent();
        Menu menu = menuItem.getMenu();
        if (menu != null && !this.menuPopup.isOpen()) {
            Display display = menuItem.getDisplay();
            Point location = menuItem.mapPointToAncestor(display, this.getWidth(), 0);
            this.menuPopup.setLocation(location.x, location.y);
            this.menuPopup.open(menuItem.getWindow());
            this.menuPopup.requestFocus();
        }
    }

    public void menuChanged(Menu.Item menuItem, Menu previousMenu) {
        this.menuPopup.setMenu(menuItem.getMenu());
        this.repaintComponent();
    }

    public void activeChanged(Menu.Item menuItem) {
        if (menuItem.isActive()) {
            menuItem.scrollAreaToVisible(0, 0, menuItem.getWidth(), menuItem.getHeight());
        } else {
            this.menuPopup.close(true);
        }
        this.repaintComponent();
    }
}

