/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.Separator;
import org.apache.pivot.wtk.SeparatorListener;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.ComponentSkin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeparatorSkin
extends ComponentSkin
implements SeparatorListener {
    private Font font;
    private Color color;
    private Color headingColor;
    private int thickness;
    private Insets padding;

    public SeparatorSkin() {
        Theme theme = Theme.getTheme();
        this.font = theme.getFont().deriveFont(1);
        this.color = Color.BLACK;
        this.headingColor = Color.BLACK;
        this.thickness = 1;
        this.padding = new Insets(4, 0, 4, 4);
    }

    @Override
    public void install(Component component) {
        super.install(component);
        Separator separator = (Separator)component;
        separator.getSeparatorListeners().add((Object)this);
    }

    @Override
    public int getPreferredWidth(int height) {
        int preferredWidth = 0;
        Separator separator = (Separator)this.getComponent();
        String heading = separator.getHeading();
        if (heading != null && heading.length() > 0) {
            FontRenderContext fontRenderContext = Platform.getFontRenderContext();
            Rectangle2D headingBounds = this.font.getStringBounds(heading, fontRenderContext);
            preferredWidth = (int)Math.ceil(headingBounds.getWidth()) + (this.padding.left + this.padding.right);
        }
        return preferredWidth;
    }

    @Override
    public int getPreferredHeight(int width) {
        int preferredHeight = this.thickness;
        Separator separator = (Separator)this.getComponent();
        String heading = separator.getHeading();
        if (heading != null && heading.length() > 0) {
            FontRenderContext fontRenderContext = Platform.getFontRenderContext();
            LineMetrics lm = this.font.getLineMetrics(heading, fontRenderContext);
            preferredHeight = Math.max((int)Math.ceil(lm.getAscent() + lm.getDescent() + lm.getLeading()), preferredHeight);
        }
        return preferredHeight += this.padding.top + this.padding.bottom;
    }

    @Override
    public Dimensions getPreferredSize() {
        int preferredWidth = 0;
        int preferredHeight = this.thickness;
        Separator separator = (Separator)this.getComponent();
        String heading = separator.getHeading();
        if (heading != null && heading.length() > 0) {
            FontRenderContext fontRenderContext = Platform.getFontRenderContext();
            Rectangle2D headingBounds = this.font.getStringBounds(heading, fontRenderContext);
            LineMetrics lm = this.font.getLineMetrics(heading, fontRenderContext);
            preferredWidth = (int)Math.ceil(headingBounds.getWidth());
            preferredHeight = Math.max((int)Math.ceil(lm.getAscent() + lm.getDescent() + lm.getLeading()), preferredHeight);
        }
        return new Dimensions(preferredWidth += this.padding.left + this.padding.right, preferredHeight += this.padding.top + this.padding.bottom);
    }

    @Override
    public void layout() {
    }

    @Override
    public void paint(Graphics2D graphics) {
        Separator separator = (Separator)this.getComponent();
        int width = this.getWidth();
        int separatorY = this.padding.top;
        String heading = separator.getHeading();
        if (heading != null && heading.length() > 0) {
            FontRenderContext fontRenderContext = Platform.getFontRenderContext();
            LineMetrics lm = this.font.getLineMetrics(heading, fontRenderContext);
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, fontRenderContext.getAntiAliasingHint());
            graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, fontRenderContext.getFractionalMetricsHint());
            graphics.setFont(this.font);
            graphics.setPaint(this.headingColor);
            graphics.drawString(heading, (float)this.padding.left, lm.getAscent() + (float)this.padding.top);
            Rectangle2D headingBounds = this.font.getStringBounds(heading, fontRenderContext);
            Area titleClip = new Area(graphics.getClip());
            titleClip.subtract(new Area(new Rectangle2D.Double(this.padding.left, this.padding.top, headingBounds.getWidth() + (double)this.padding.right, headingBounds.getHeight())));
            graphics.clip(titleClip);
            separatorY = (int)((float)separatorY + ((lm.getAscent() + lm.getDescent()) / 2.0f + 1.0f));
        }
        graphics.setStroke(new BasicStroke(this.thickness));
        graphics.setColor(this.color);
        graphics.drawLine(0, separatorY, width, separatorY);
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(SeparatorSkin.decodeFont(font));
    }

    public final void setFont(Dictionary<String, ?> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(font));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor(color));
    }

    public Color getHeadingColor() {
        return this.headingColor;
    }

    public void setHeadingColor(Color headingColor) {
        if (headingColor == null) {
            throw new IllegalArgumentException("headingColor is null.");
        }
        this.headingColor = headingColor;
        this.repaintComponent();
    }

    public final void setHeadingColor(String headingColor) {
        if (headingColor == null) {
            throw new IllegalArgumentException("headingColor is null.");
        }
        this.setHeadingColor(GraphicsUtilities.decodeColor(headingColor));
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int thickness) {
        if (thickness < 0) {
            throw new IllegalArgumentException("thickness is negative.");
        }
        this.thickness = thickness;
        this.invalidateComponent();
    }

    public final void setThickness(Number thickness) {
        if (thickness == null) {
            throw new IllegalArgumentException("thickness is null.");
        }
        this.setThickness(thickness.intValue());
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = padding;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(int padding) {
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(padding.intValue());
    }

    public final void setPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode(padding));
    }

    @Override
    public void headingChanged(Separator separator, String previousHeading) {
        this.invalidateComponent();
    }
}

