/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Graphics2D;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentListener;
import org.apache.pivot.wtk.TextPane;
import org.apache.pivot.wtk.skin.TextPaneSkinNodeView;
import org.apache.pivot.wtk.text.ComponentNode;
import org.apache.pivot.wtk.text.ComponentNodeListener;

class TextPaneSkinComponentNodeView
extends TextPaneSkinNodeView
implements ComponentNodeListener {
    private final ComponentListener myComponentListener = new ComponentListener.Adapter(){

        public void sizeChanged(Component component, int previousWidth, int previousHeight) {
            TextPaneSkinComponentNodeView.this.invalidate();
        }
    };

    public TextPaneSkinComponentNodeView(ComponentNode componentNode) {
        super(componentNode);
    }

    protected void attach() {
        super.attach();
        ComponentNode componentNode = (ComponentNode)this.getNode();
        componentNode.getComponentNodeListeners().add((Object)this);
        Component component = componentNode.getComponent();
        if (component != null) {
            component.getComponentListeners().add((Object)this.myComponentListener);
        }
    }

    protected void detach() {
        super.detach();
        ComponentNode componentNode = (ComponentNode)this.getNode();
        componentNode.getComponentNodeListeners().remove((Object)this);
    }

    public void validate() {
        if (!this.isValid()) {
            ComponentNode componentNode = (ComponentNode)this.getNode();
            Component component = componentNode.getComponent();
            if (component == null) {
                this.setSize(0, 0);
            } else {
                component.validate();
                component.setSize(component.getPreferredWidth(), component.getPreferredHeight());
                this.setSize(component.getWidth(), component.getHeight());
            }
            super.validate();
        }
    }

    protected void setSkinLocation(int skinX, int skinY) {
        ComponentNode componentNode = (ComponentNode)this.getNode();
        Component component = componentNode.getComponent();
        if (component != null) {
            component.setLocation(skinX, skinY);
        }
    }

    public void paint(Graphics2D graphics) {
    }

    public TextPaneSkinNodeView getNext() {
        return null;
    }

    public int getInsertionPoint(int x, int y) {
        return 0;
    }

    public int getNextInsertionPoint(int x, int from, TextPane.ScrollDirection direction) {
        return from == -1 ? 0 : -1;
    }

    public int getRowAt(int offset) {
        return -1;
    }

    public int getRowCount() {
        return 0;
    }

    public Bounds getCharacterBounds(int offset) {
        return new Bounds(0, 0, this.getWidth(), this.getHeight());
    }

    public void componentChanged(ComponentNode componentNode, Component previousComponent) {
        this.invalidate();
        Component component = componentNode.getComponent();
        if (component != null) {
            component.getComponentListeners().add((Object)this.myComponentListener);
        }
        if (previousComponent != null) {
            previousComponent.getComponentListeners().remove((Object)this.myComponentListener);
        }
    }
}

