/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Graphics2D;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.TextPane;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.media.ImageListener;
import org.apache.pivot.wtk.skin.TextPaneSkinNodeView;
import org.apache.pivot.wtk.text.ImageNode;
import org.apache.pivot.wtk.text.ImageNodeListener;

class TextPaneSkinImageNodeView
extends TextPaneSkinNodeView
implements ImageNodeListener,
ImageListener {
    public TextPaneSkinImageNodeView(ImageNode imageNode) {
        super(imageNode);
    }

    protected void attach() {
        super.attach();
        ImageNode imageNode = (ImageNode)this.getNode();
        imageNode.getImageNodeListeners().add((Object)this);
        Image image = imageNode.getImage();
        if (image != null) {
            image.getImageListeners().add((Object)this);
        }
    }

    protected void detach() {
        super.detach();
        ImageNode imageNode = (ImageNode)this.getNode();
        imageNode.getImageNodeListeners().remove((Object)this);
    }

    public void validate() {
        if (!this.isValid()) {
            ImageNode imageNode = (ImageNode)this.getNode();
            Image image = imageNode.getImage();
            if (image == null) {
                this.setSize(0, 0);
            } else {
                this.setSize(image.getWidth(), image.getHeight());
            }
            super.validate();
        }
    }

    protected void setSkinLocation(int skinX, int skinY) {
    }

    public void paint(Graphics2D graphics) {
        ImageNode imageNode = (ImageNode)this.getNode();
        Image image = imageNode.getImage();
        if (image != null) {
            image.paint(graphics);
        }
    }

    public TextPaneSkinNodeView getNext() {
        return null;
    }

    public int getInsertionPoint(int x, int y) {
        return 0;
    }

    public int getNextInsertionPoint(int x, int from, TextPane.ScrollDirection direction) {
        return from == -1 ? 0 : -1;
    }

    public int getRowAt(int offset) {
        return -1;
    }

    public int getRowCount() {
        return 0;
    }

    public Bounds getCharacterBounds(int offset) {
        return new Bounds(0, 0, this.getWidth(), this.getHeight());
    }

    public void imageChanged(ImageNode imageNode, Image previousImage) {
        this.invalidate();
        Image image = imageNode.getImage();
        if (image != null) {
            image.getImageListeners().add((Object)this);
        }
        if (previousImage != null) {
            previousImage.getImageListeners().remove((Object)this);
        }
    }

    public void sizeChanged(Image image, int previousWidth, int previousHeight) {
        this.invalidate();
    }

    public void baselineChanged(Image image, int previousBaseline) {
    }

    public void regionUpdated(Image image, int x, int y, int width, int height) {
        this.repaint(x, y, width, height);
    }
}

