/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.util.Iterator;
import org.apache.pivot.wtk.skin.TextPaneSkin;
import org.apache.pivot.wtk.skin.TextPaneSkinNodeView;
import org.apache.pivot.wtk.skin.TextPaneSkinTextNodeView;
import org.apache.pivot.wtk.skin.TextPaneSkinVerticalElementView;
import org.apache.pivot.wtk.text.List;
import org.apache.pivot.wtk.text.TextNode;

class TextPaneSkinListItemView
extends TextPaneSkinVerticalElementView {
    private TextNode indexTextNode = new TextNode("");
    private TextPaneSkinTextNodeView indexTextNodeView;

    public TextPaneSkinListItemView(TextPaneSkin textPaneSkin, List.Item listItem) {
        super(textPaneSkin, listItem);
    }

    protected void attach() {
        super.attach();
        this.indexTextNodeView = new TextPaneSkinTextNodeView(this.textPaneSkin, this.indexTextNode);
        this.insert(this.indexTextNodeView, 0);
    }

    public void setIndexText(String indexText) {
        this.indexTextNode.setText(indexText);
        this.indexTextNodeView.setBreakWidth(Integer.MAX_VALUE);
        this.indexTextNodeView.validate();
        this.indexTextNodeView.setLocation(0, 0);
    }

    public void validate() {
        if (!this.isValid()) {
            this.indexTextNodeView.validate();
            this.indexTextNodeView.setLocation(0, 0);
            int breakWidth = this.getBreakWidth() - this.indexTextNodeView.getWidth();
            int itemsWidth = 0;
            int itemsY = 0;
            Iterator<TextPaneSkinNodeView> iterator = this.iterator();
            iterator.next();
            while (iterator.hasNext()) {
                TextPaneSkinNodeView nodeView = iterator.next();
                nodeView.setBreakWidth(breakWidth);
                nodeView.validate();
                nodeView.setLocation(this.indexTextNodeView.getWidth(), itemsY);
                itemsWidth = Math.max(itemsWidth, nodeView.getWidth());
                itemsY += nodeView.getHeight();
            }
            int width = itemsWidth + this.indexTextNodeView.getWidth();
            int height = Math.max(itemsY, this.indexTextNodeView.getHeight());
            this.setSize(width, height);
            super.validate();
        }
    }

    public int getIndexTextWidth() {
        return this.indexTextNodeView.getWidth();
    }
}

