/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.TextPane;
import org.apache.pivot.wtk.skin.TextPaneSkin;
import org.apache.pivot.wtk.skin.TextPaneSkinElementView;
import org.apache.pivot.wtk.skin.TextPaneSkinNodeView;
import org.apache.pivot.wtk.skin.TextPaneSkinTextNodeView;
import org.apache.pivot.wtk.text.Element;
import org.apache.pivot.wtk.text.Node;
import org.apache.pivot.wtk.text.Span;
import org.apache.pivot.wtk.text.TextNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TextPaneSkinSpanView
extends TextPaneSkinElementView {
    private final TextPaneSkin textPaneSkin;

    public TextPaneSkinSpanView(TextPaneSkin textPaneSkin, Span span) {
        super(span);
        this.textPaneSkin = textPaneSkin;
    }

    @Override
    public void validate() {
        if (!this.isValid()) {
            this.remove(0, this.getLength());
            Span span = (Span)this.getNode();
            if (span.getLength() > 1) {
                throw new IllegalStateException();
            }
            if (span.getLength() == 0) {
                this.setSize(0, 0);
            } else {
                this.add(new TextPaneSkinTextNodeView(this.textPaneSkin, (TextNode)span.get(0), 0));
                int breakWidth = this.getBreakWidth();
                TextPaneSkinNodeView nodeView = this.get(0);
                nodeView.setBreakWidth(breakWidth);
                nodeView.validate();
                this.setSize(nodeView.getWidth(), nodeView.getHeight());
            }
        }
        super.validate();
    }

    @Override
    public int getCharacterCount() {
        if (this.getLength() == 0) {
            return 0;
        }
        return this.get(0).getCharacterCount();
    }

    @Override
    public TextPaneSkinNodeView getNext() {
        if (this.getLength() == 0) {
            return null;
        }
        return this.get(0).getNext();
    }

    @Override
    public int getInsertionPoint(int x, int y) {
        if (this.getLength() == 0) {
            return -1;
        }
        return this.get(0).getInsertionPoint(x, y);
    }

    @Override
    public int getNextInsertionPoint(int x, int from, TextPane.ScrollDirection direction) {
        if (this.getLength() == 0) {
            return -1;
        }
        return this.get(0).getNextInsertionPoint(x, from, direction);
    }

    @Override
    public int getRowCount() {
        if (this.getLength() == 0) {
            return 0;
        }
        return this.get(0).getRowCount();
    }

    @Override
    public int getRowAt(int offset) {
        if (this.getLength() == 0) {
            return 0;
        }
        return this.get(0).getRowAt(offset);
    }

    @Override
    protected void setSkinLocation(int skinX, int skinY) {
        for (TextPaneSkinNodeView nodeView : this) {
            nodeView.setSkinLocation(skinX, skinY + nodeView.getY());
        }
    }

    @Override
    public void nodeInserted(Element element, int index) {
        super.nodeInserted(element, index);
        Span span = (Span)this.getNode();
        this.insert(this.textPaneSkin.createNodeView(span.get(index)), index);
    }

    @Override
    public void nodesRemoved(Element element, int index, Sequence<Node> nodes) {
        this.remove(index, nodes.getLength());
        super.nodesRemoved(element, index, nodes);
    }
}

