/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.text.CharacterIterator;
import org.apache.pivot.text.CharSequenceCharacterIterator;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.Span;
import org.apache.pivot.wtk.TextPane;
import org.apache.pivot.wtk.skin.TextPaneSkin;
import org.apache.pivot.wtk.skin.TextPaneSkinNodeView;
import org.apache.pivot.wtk.text.Element;
import org.apache.pivot.wtk.text.TextNode;
import org.apache.pivot.wtk.text.TextNodeListener;

class TextPaneSkinTextNodeView
extends TextPaneSkinNodeView
implements TextNodeListener {
    private final TextPaneSkin textPaneSkin;
    private int start;
    private int length = 0;
    private GlyphVector glyphVector = null;
    private TextPaneSkinTextNodeView next = null;

    public TextPaneSkinTextNodeView(TextPaneSkin textPaneSkin, TextNode textNode) {
        this(textPaneSkin, textNode, 0);
    }

    public TextPaneSkinTextNodeView(TextPaneSkin textPaneSkin, TextNode textNode, int start) {
        super(textNode);
        this.textPaneSkin = textPaneSkin;
        this.start = start;
    }

    protected void attach() {
        super.attach();
        TextNode textNode = (TextNode)this.getNode();
        textNode.getTextNodeListeners().add((Object)this);
    }

    protected void detach() {
        super.detach();
        TextNode textNode = (TextNode)this.getNode();
        textNode.getTextNodeListeners().remove((Object)this);
    }

    public void invalidate() {
        this.length = 0;
        this.next = null;
        this.glyphVector = null;
        super.invalidate();
    }

    public void validate() {
        if (!this.isValid()) {
            int end;
            TextNode textNode = (TextNode)this.getNode();
            FontRenderContext fontRenderContext = Platform.getFontRenderContext();
            int breakWidth = this.getBreakWidth();
            CharSequenceCharacterIterator ci = new CharSequenceCharacterIterator(textNode.getCharacters(), this.start);
            float lineWidth = 0.0f;
            int lastWhitespaceIndex = -1;
            Font effectiveFont = this.getEffectiveFont();
            char c = ci.first();
            while (c != '\uffff' && lineWidth < (float)breakWidth) {
                if (Character.isWhitespace(c)) {
                    lastWhitespaceIndex = ci.getIndex();
                }
                int i = ci.getIndex();
                Rectangle2D characterBounds = effectiveFont.getStringBounds((CharacterIterator)ci, i, i + 1, fontRenderContext);
                lineWidth = (float)((double)lineWidth + characterBounds.getWidth());
                c = ci.current();
            }
            if (this.textPaneSkin.getWrapText()) {
                if (textNode.getCharacterCount() == 0) {
                    end = this.start;
                } else if (lineWidth < (float)breakWidth) {
                    end = ci.getEndIndex();
                } else if (lastWhitespaceIndex == -1) {
                    end = ci.getIndex() - 1;
                    if (end <= this.start) {
                        end = this.start + 1;
                    }
                } else {
                    end = lastWhitespaceIndex + 1;
                }
            } else {
                end = ci.getEndIndex();
            }
            this.glyphVector = this.getEffectiveFont().createGlyphVector(fontRenderContext, (CharacterIterator)new CharSequenceCharacterIterator(textNode.getCharacters(), this.start, end));
            if (end < ci.getEndIndex()) {
                this.length = end - this.start;
                this.next = new TextPaneSkinTextNodeView(this.textPaneSkin, textNode, end);
            } else {
                this.length = ci.getEndIndex() - this.start;
            }
            Rectangle2D textBounds = this.glyphVector.getLogicalBounds();
            this.setSize((int)Math.ceil(textBounds.getWidth()), (int)Math.ceil(textBounds.getHeight()));
        }
        super.validate();
    }

    protected void setSkinLocation(int skinX, int skinY) {
    }

    public void paint(Graphics2D graphics) {
        if (this.glyphVector != null) {
            TextPane textPane = (TextPane)this.textPaneSkin.getComponent();
            FontRenderContext fontRenderContext = Platform.getFontRenderContext();
            LineMetrics lm = this.getEffectiveFont().getLineMetrics("", fontRenderContext);
            float ascent = lm.getAscent();
            int strikethroughX = Math.round(lm.getAscent() + lm.getStrikethroughOffset());
            int underlineX = Math.round(lm.getAscent() + lm.getUnderlineOffset());
            boolean underline = this.getEffectiveUnderline();
            boolean strikethrough = this.getEffectiveStrikethrough();
            graphics.setFont(this.getEffectiveFont());
            int selectionStart = textPane.getSelectionStart();
            int selectionLength = textPane.getSelectionLength();
            Span selectionRange = new Span(selectionStart, selectionStart + selectionLength - 1);
            int documentOffset = this.getDocumentOffset();
            Span characterRange = new Span(documentOffset, documentOffset + this.getCharacterCount() - 1);
            int width = this.getWidth();
            int height = this.getHeight();
            if (selectionLength > 0 && characterRange.intersects(selectionRange)) {
                int x1;
                int x0;
                if (selectionRange.start > characterRange.start) {
                    Bounds leadingSelectionBounds = this.getCharacterBounds(selectionRange.start - documentOffset);
                    x0 = leadingSelectionBounds.x;
                } else {
                    x0 = 0;
                }
                if (selectionRange.end < characterRange.end) {
                    Bounds trailingSelectionBounds = this.getCharacterBounds(selectionRange.end - documentOffset);
                    x1 = trailingSelectionBounds.x + trailingSelectionBounds.width;
                } else {
                    x1 = width;
                }
                Rectangle selection = new Rectangle(x0, 0, x1 - x0, height);
                Area unselectedArea = new Area();
                unselectedArea.add(new Area(new Rectangle(0, 0, width, height)));
                unselectedArea.subtract(new Area(selection));
                Graphics2D textGraphics = (Graphics2D)graphics.create();
                textGraphics.setColor(this.getEffectiveForegroundColor());
                textGraphics.clip(unselectedArea);
                textGraphics.drawGlyphVector(this.glyphVector, 0.0f, ascent);
                if (underline) {
                    textGraphics.drawLine(x0, underlineX, x1 - x0, underlineX);
                }
                if (strikethrough) {
                    textGraphics.drawLine(x0, strikethroughX, x1 - x0, strikethroughX);
                }
                textGraphics.dispose();
                Color selectionColor = textPane.isFocused() ? this.textPaneSkin.getSelectionColor() : this.textPaneSkin.getInactiveSelectionColor();
                Graphics2D selectedTextGraphics = (Graphics2D)graphics.create();
                selectedTextGraphics.setColor(textPane.isFocused() && textPane.isEditable() ? selectionColor : this.textPaneSkin.getInactiveSelectionColor());
                selectedTextGraphics.clip(selection.getBounds());
                selectedTextGraphics.drawGlyphVector(this.glyphVector, 0.0f, ascent);
                if (underline) {
                    selectedTextGraphics.drawLine(0, underlineX, width, underlineX);
                }
                if (strikethrough) {
                    selectedTextGraphics.drawLine(0, strikethroughX, width, strikethroughX);
                }
                selectedTextGraphics.dispose();
            } else {
                graphics.setColor(this.getEffectiveForegroundColor());
                graphics.drawGlyphVector(this.glyphVector, 0.0f, ascent);
                if (underline) {
                    graphics.drawLine(0, underlineX, width, underlineX);
                }
                if (strikethrough) {
                    graphics.drawLine(0, strikethroughX, width, strikethroughX);
                }
            }
        }
    }

    public int getOffset() {
        return super.getOffset() + this.start;
    }

    public int getCharacterCount() {
        return this.length;
    }

    public TextPaneSkinNodeView getNext() {
        return this.next;
    }

    public int getInsertionPoint(int x, int y) {
        int i;
        FontRenderContext fontRenderContext = Platform.getFontRenderContext();
        LineMetrics lm = this.getEffectiveFont().getLineMetrics("", fontRenderContext);
        float ascent = lm.getAscent();
        int n = this.glyphVector.getNumGlyphs();
        for (i = 0; i < n; ++i) {
            Shape glyphBounds = this.glyphVector.getGlyphLogicalBounds(i);
            if (!glyphBounds.contains(x, (float)y - ascent)) continue;
            Rectangle2D glyphBounds2D = glyphBounds.getBounds2D();
            if (!((double)x - glyphBounds2D.getX() > glyphBounds2D.getWidth() / 2.0) || i >= n - 1) break;
            ++i;
            break;
        }
        return i;
    }

    private Font getEffectiveFont() {
        Element element;
        Font font = null;
        for (element = this.getNode().getParent(); element != null && (font = element.getFont()) == null; element = element.getParent()) {
        }
        if (element == null) {
            font = this.textPaneSkin.getFont();
        }
        return font;
    }

    private Color getEffectiveForegroundColor() {
        Element element;
        Color foregroundColor = null;
        for (element = this.getNode().getParent(); element != null && (foregroundColor = element.getForegroundColor()) == null; element = element.getParent()) {
        }
        if (element == null) {
            foregroundColor = this.textPaneSkin.getColor();
        }
        return foregroundColor;
    }

    private boolean getEffectiveUnderline() {
        for (Element element = this.getNode().getParent(); element != null; element = element.getParent()) {
            if (!element.isUnderline()) continue;
            return true;
        }
        return false;
    }

    private boolean getEffectiveStrikethrough() {
        for (Element element = this.getNode().getParent(); element != null; element = element.getParent()) {
            if (!element.isStrikethrough()) continue;
            return true;
        }
        return false;
    }

    public int getNextInsertionPoint(int x, int from, TextPane.ScrollDirection direction) {
        int offset = -1;
        if (from == -1) {
            int n = this.glyphVector.getNumGlyphs();
            for (int i = 0; i < n; ++i) {
                Shape glyphBounds = this.glyphVector.getGlyphLogicalBounds(i);
                Rectangle2D glyphBounds2D = glyphBounds.getBounds2D();
                float glyphX = (float)glyphBounds2D.getX();
                float glyphWidth = (float)glyphBounds2D.getWidth();
                if (!((float)x >= glyphX) || !((float)x < glyphX + glyphWidth)) continue;
                if ((float)x - glyphX > glyphWidth / 2.0f && i < n - 1) {
                    ++i;
                }
                offset = i;
                break;
            }
        }
        return offset;
    }

    public int getRowAt(int offset) {
        return -1;
    }

    public int getRowCount() {
        return 0;
    }

    public Bounds getCharacterBounds(int offset) {
        Shape glyphBounds = this.glyphVector.getGlyphLogicalBounds(offset);
        Rectangle2D glyphBounds2D = glyphBounds.getBounds2D();
        return new Bounds((int)Math.floor(glyphBounds2D.getX()), 0, (int)Math.ceil(glyphBounds2D.getWidth()), this.getHeight());
    }

    public void charactersInserted(TextNode textNode, int index, int count) {
        this.invalidate();
    }

    public void charactersRemoved(TextNode textNode, int index, int count) {
        this.invalidate();
    }

    public String toString() {
        TextNode textNode = (TextNode)this.getNode();
        String text = textNode.getText();
        return "[" + text.substring(this.start, this.start + this.length) + "]";
    }
}

