/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.TextPane;
import org.apache.pivot.wtk.skin.TextPaneSkin;
import org.apache.pivot.wtk.skin.TextPaneSkinElementView;
import org.apache.pivot.wtk.skin.TextPaneSkinNodeView;
import org.apache.pivot.wtk.text.Element;
import org.apache.pivot.wtk.text.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TextPaneSkinVerticalElementView
extends TextPaneSkinElementView {
    protected final TextPaneSkin textPaneSkin;

    public TextPaneSkinVerticalElementView(TextPaneSkin textPaneSkin, Element element) {
        super(element);
        this.textPaneSkin = textPaneSkin;
    }

    @Override
    protected void attach() {
        super.attach();
        Element element = (Element)this.getNode();
        for (Node node : element) {
            this.add(this.textPaneSkin.createNodeView(node));
        }
    }

    protected void verticalValidate() {
        int breakWidth = this.getBreakWidth();
        int width = 0;
        int height = 0;
        for (TextPaneSkinNodeView nodeView : this) {
            nodeView.setBreakWidth(breakWidth);
            nodeView.validate();
            nodeView.setLocation(0, height);
            width = Math.max(width, nodeView.getWidth());
            height += nodeView.getHeight();
        }
        this.setSize(width, height);
    }

    @Override
    protected void setSkinLocation(int skinX, int skinY) {
        for (TextPaneSkinNodeView nodeView : this) {
            nodeView.setSkinLocation(skinX, skinY + nodeView.getY());
        }
    }

    @Override
    public TextPaneSkinNodeView getNext() {
        return null;
    }

    @Override
    public int getInsertionPoint(int x, int y) {
        int offset = -1;
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            TextPaneSkinNodeView nodeView = this.get(i);
            Bounds nodeViewBounds = nodeView.getBounds();
            if (y < nodeViewBounds.y || y >= nodeViewBounds.y + nodeViewBounds.height) continue;
            offset = nodeView.getInsertionPoint(x - nodeView.getX(), y - nodeView.getY()) + nodeView.getOffset();
            break;
        }
        return offset;
    }

    @Override
    public int getNextInsertionPoint(int x, int from, TextPane.ScrollDirection direction) {
        int offset = -1;
        if (this.getLength() > 0) {
            if (from == -1) {
                int i = direction == TextPane.ScrollDirection.DOWN ? 0 : this.getLength() - 1;
                TextPaneSkinNodeView nodeView = this.get(i);
                offset = nodeView.getNextInsertionPoint(x - nodeView.getX(), -1, direction);
                if (offset != -1) {
                    offset += nodeView.getOffset();
                }
            } else {
                TextPaneSkinNodeView nodeView;
                int i;
                int n = this.getLength();
                for (i = 0; i < n; ++i) {
                    nodeView = this.get(i);
                    int nodeViewOffset = nodeView.getOffset();
                    int characterCount = nodeView.getCharacterCount();
                    if (from >= nodeViewOffset && from < nodeViewOffset + characterCount) break;
                }
                if (i < n) {
                    nodeView = this.get(i);
                    offset = nodeView.getNextInsertionPoint(x - nodeView.getX(), from - nodeView.getOffset(), direction);
                    if (offset == -1) {
                        if (direction == TextPane.ScrollDirection.DOWN) {
                            nodeView = i < n - 1 ? this.get(i + 1) : null;
                        } else {
                            TextPaneSkinNodeView textPaneSkinNodeView = nodeView = i > 0 ? this.get(i - 1) : null;
                        }
                        if (nodeView != null) {
                            offset = nodeView.getNextInsertionPoint(x - nodeView.getX(), -1, direction);
                        }
                    }
                    if (offset != -1) {
                        offset += nodeView.getOffset();
                    }
                }
            }
        }
        return offset;
    }

    @Override
    public int getRowAt(int offset) {
        int rowIndex = 0;
        for (TextPaneSkinNodeView nodeView : this) {
            int nodeViewOffset = nodeView.getOffset();
            int characterCount = nodeView.getCharacterCount();
            if (offset >= nodeViewOffset && offset < nodeViewOffset + characterCount) {
                rowIndex += nodeView.getRowAt(offset - nodeView.getOffset());
                break;
            }
            rowIndex += nodeView.getRowCount();
        }
        return rowIndex;
    }

    @Override
    public int getRowCount() {
        int rowCount = 0;
        for (TextPaneSkinNodeView nodeView : this) {
            rowCount += nodeView.getRowCount();
        }
        return rowCount;
    }

    @Override
    public void nodeInserted(Element element, int index) {
        super.nodeInserted(element, index);
        this.insert(this.textPaneSkin.createNodeView(element.get(index)), index);
    }

    @Override
    public void nodesRemoved(Element element, int index, Sequence<Node> nodes) {
        this.remove(index, nodes.getLength());
        super.nodesRemoved(element, index, nodes);
    }
}

