/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.text;

import java.net.URL;
import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.text.ImageNodeListener;
import org.apache.pivot.wtk.text.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageNode
extends Node {
    private Image image = null;
    private ImageNodeListenerList imageNodeListeners = new ImageNodeListenerList();

    public ImageNode() {
    }

    public ImageNode(ImageNode imageNode) {
        this.setImage(imageNode.getImage());
    }

    public ImageNode(Image image) {
        this.setImage(image);
    }

    public ImageNode(URL image) {
        this.setImage(image);
    }

    public ImageNode(String image) {
        this.setImage(image);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        Image previousImage = this.image;
        if (previousImage != image) {
            this.image = image;
            this.imageNodeListeners.imageChanged(this, previousImage);
        }
    }

    public void setImage(URL imageURL) {
        if (imageURL == null) {
            throw new IllegalArgumentException("imageURL is null.");
        }
        Image image = (Image)ApplicationContext.getResourceCache().get(imageURL);
        if (image == null) {
            try {
                image = Image.load(imageURL);
            }
            catch (TaskExecutionException exception) {
                throw new IllegalArgumentException(exception);
            }
            ApplicationContext.getResourceCache().put(imageURL, (Object)image);
        }
        this.setImage(image);
    }

    public void setImage(String imageName) {
        if (imageName == null) {
            throw new IllegalArgumentException("imageName is null.");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.setImage(classLoader.getResource(imageName.substring(1)));
    }

    @Override
    public char getCharacterAt(int offset) {
        return '\u0000';
    }

    @Override
    public int getCharacterCount() {
        return 1;
    }

    @Override
    public void insertRange(Node range, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node removeRange(int offset, int span) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getRange(int offset, int characterCount) {
        if (offset < 0 || offset > 1) {
            throw new IndexOutOfBoundsException();
        }
        if (characterCount != 1) {
            throw new IllegalArgumentException("Invalid characterCount.");
        }
        return new ImageNode(this);
    }

    @Override
    public Node duplicate(boolean recursive) {
        return new ImageNode(this);
    }

    public ListenerList<ImageNodeListener> getImageNodeListeners() {
        return this.imageNodeListeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImageNodeListenerList
    extends ListenerList<ImageNodeListener>
    implements ImageNodeListener {
        private ImageNodeListenerList() {
        }

        @Override
        public void imageChanged(ImageNode imageNode, Image previousImage) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ImageNodeListener listener = (ImageNodeListener)i$.next();
                listener.imageChanged(imageNode, previousImage);
            }
        }
    }
}

