/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.j3d.community.utils.geometry;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import javax.vecmath.Point2f;

public class AWTShapeExtrusion {
    private float length = 0.2f;
    private Shape shape = null;
    private Point2f[] pnts = null;
    private boolean isT3DExtrusion = false;
    private double tessellationTolerance = 0.01;

    public AWTShapeExtrusion() {
    }

    public AWTShapeExtrusion(float depth) {
        if (depth < 0.0f) {
            throw new IllegalArgumentException("Length of extrusion is less than 0.0; depth = " + depth + " !");
        }
        this.length = depth;
    }

    public AWTShapeExtrusion(Shape extrusionShape) {
        this.setExtrusionShape(extrusionShape);
    }

    public AWTShapeExtrusion(Shape extrusionShape, double tessellationTolerance) {
        this.tessellationTolerance = tessellationTolerance;
        this.setExtrusionShape(extrusionShape);
    }

    public Shape getExtrusionShape() {
        return this.shape;
    }

    public void setExtrusionShape(Shape extrusionShape) {
        this.shape = extrusionShape;
        if (this.shape == null) {
            this.length = 0.2f;
            this.pnts = null;
            return;
        }
        this.updateExtrusionShape();
    }

    public void setStraightBevelExtrusionShape(float depth) {
        if (depth < 0.0f) {
            throw new IllegalArgumentException("Length of extrusion is less than 0.0; depth = " + depth + " !");
        }
        this.length = depth;
        this.shape = null;
        this.pnts = null;
    }

    private void updateExtrusionShape() {
        if (this.shape == null) {
            throw new IllegalStateException("Extrusion shape is null !!");
        }
        PathIterator pIt = this.shape.getPathIterator(null, this.tessellationTolerance);
        ArrayList<Point2f> coords = new ArrayList<Point2f>();
        float[] tmpCoords = new float[6];
        float prevX = 0.0f;
        int n = 0;
        int inc = -1;
        while (!pIt.isDone()) {
            Point2f vertex = new Point2f();
            int flag = pIt.currentSegment(tmpCoords);
            if (flag == 1) {
                vertex.x = tmpCoords[0];
                vertex.y = tmpCoords[1];
                if (inc == -1) {
                    if (prevX < vertex.x) {
                        inc = 0;
                    } else if (prevX > vertex.x) {
                        inc = 1;
                    }
                }
                if (inc == 0 && prevX > vertex.x || inc == 1 && prevX < vertex.x) {
                    throw new IllegalArgumentException("AWTShapeExtrusion:invalid shape- non-monotonic");
                }
                prevX = vertex.x;
                ++n;
                coords.add(vertex);
            } else if (flag == 0) {
                if (n != 0) {
                    throw new IllegalArgumentException("AWTShapeExtrusion:invalid shape- multiple contours");
                }
                vertex.x = tmpCoords[0];
                vertex.y = tmpCoords[1];
                prevX = vertex.x;
                ++n;
                coords.add(vertex);
            }
            pIt.next();
        }
        int num = coords.size();
        this.pnts = new Point2f[num];
        if (inc == 0) {
            int i = 0;
            while (i < num) {
                this.pnts[i] = (Point2f)coords.get(i);
                ++i;
            }
        } else {
            int i = 0;
            while (i < num) {
                this.pnts[i] = (Point2f)coords.get(num - i - 1);
                ++i;
            }
        }
        this.pnts[num - 1].y = 0.0f;
        if (this.pnts[0].x != 0.0f) {
            throw new IllegalArgumentException("AWTShapeExtrusion: invalid shape - shape must start or end at x = 0.0f");
        }
        float dx = this.pnts[0].x - this.pnts[num - 1].x;
        float dy = this.pnts[0].y - this.pnts[num - 1].y;
        this.length = (float)Math.sqrt(dx * dx + dy * dy);
    }

    public double getTessellationTolerance() {
        return this.tessellationTolerance;
    }

    public void setTessellationTolerance(double tessellationTolerance) {
        this.tessellationTolerance = tessellationTolerance;
        if (this.shape != null) {
            this.updateExtrusionShape();
        }
    }

    public boolean isT3DStyleExtrusion() {
        return this.isT3DExtrusion;
    }

    public void setT3DStyleExtrusion(boolean enable) {
        this.isT3DExtrusion = enable;
    }

    public Point2f[] getExtrusion() {
        return this.pnts;
    }

    public float getDepth() {
        return this.length;
    }
}

