package com.interactivemesh.j3d.testspace.jcanvas3d;

import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.JFrame;

/**
 * Stereoscopic3DJWS.java
 *
 * Version: 0.5
 * Date: 2009/04/29
 *
 * Copyright (c) 2009
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
 * Please create your own implementation.
 * This source code is provided "AS IS", without warranty of any kind.
 * You are allowed to copy and use all lines you like of this source code
 * without any copyright notice,
 * but you may not modify, compile, or distribute this 'Stereoscopic3DJWS.java'.
 *
 */
final class Stereoscopic3DJWS {
    
    public static void main(String[] args) {  
        new Stereoscopic3DJWS();
    }

    private Stereoscopic3DJWS() {

        JFrame jFrame = new JFrame();
        jFrame.setTitle("InteractiveMesh : Stereoscopic 3D  (Proof of Concept)");
        jFrame.setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        
        
        Stereoscopic3DPanel panel = new Stereoscopic3DPanel();
        
        panel.addTo(jFrame.getContentPane(), jFrame.getLayeredPane());
                
        
        jFrame.pack();
        
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
       
        Dimension jframeDim = jFrame.getSize();
        jFrame.setLocation((screenDim.width - jframeDim.width)/2, (screenDim.height - jframeDim.height)/2);

        jFrame.setVisible(true);
    }   

}
