/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.j3d.community.gui;

import com.sun.j3d.exp.swing.impl.AutoOffScreenCanvas3D;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Screen3D;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public abstract class JCanvas3DOBAbstract
extends JPanel
implements AncestorListener {
    private static double METERS_PER_PIXEL = 2.8222222222222223E-4;
    private GraphicsConfiguration graphicsConfig;
    private InternalCanvas3D canvas;
    protected BufferedImage paintImage = null;
    protected volatile int imageWidth = 0;
    protected volatile int imageHeight = 0;

    protected JCanvas3DOBAbstract() {
        this(null, null);
    }

    protected JCanvas3DOBAbstract(GraphicsDevice device) {
        this(null, device);
    }

    protected JCanvas3DOBAbstract(GraphicsConfigTemplate3D template) {
        this(template, null);
    }

    protected JCanvas3DOBAbstract(GraphicsConfigTemplate3D template, GraphicsDevice device) {
        if (template == null) {
            template = new GraphicsConfigTemplate3D();
        }
        template.setStereo(3);
        template.setDoubleBuffer(3);
        this.graphicsConfig = device == null ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)template) : device.getBestConfiguration((GraphicsConfigTemplate)template);
        this.addAncestorListener(this);
        this.setDoubleBuffered(false);
        this.setFocusable(true);
    }

    public void ancestorAdded(AncestorEvent event) {
        Dimension sz = this.getSize();
        if (sz.width == 0) {
            sz.width = 100;
        }
        if (sz.height == 0) {
            sz.height = 100;
        }
        this.createOffScreenBuffer(sz.width, sz.height);
        this.canvas.addNotifyFlag = true;
        this.canvas.addNotify();
    }

    public void ancestorMoved(AncestorEvent event) {
    }

    public void ancestorRemoved(AncestorEvent event) {
        this.canvas.removeNotify();
    }

    public Canvas3D getOffscreenCanvas3D() {
        if (this.canvas == null) {
            this.createOffScreenBuffer(this.getWidth(), this.getHeight());
        }
        return this.canvas;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.createOffScreenBuffer(width, height);
    }

    protected void createOffScreenBuffer(int width, int height) {
        this.createCanvas(width, height);
    }

    protected void offScreenBufferCreated() {
    }

    protected void offScreenBufferCopied() {
    }

    protected final boolean isReadyForDrawing() {
        return this.paintImage != null && this.canvas.isRendererRunning();
    }

    private void createCanvas(final int width, final int height) {
        if (this.getParent() == null) {
            return;
        }
        if (this.canvas == null) {
            this.canvas = new InternalCanvas3D(this.graphicsConfig);
        } else if (this.canvas.getWidth() == width && this.canvas.getHeight() == height) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.canvas.createOffScreenBuffers(this.graphicsConfig.getBounds(), width, height);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JCanvas3DOBAbstract.this.canvas.createOffScreenBuffers(JCanvas3DOBAbstract.this.graphicsConfig.getBounds(), width, height);
                }
            });
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    protected void processComponentKeyEvent(KeyEvent e) {
        super.processComponentKeyEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processComponentEvent(e);
        e.setSource(src);
    }

    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processFocusEvent(e);
        e.setSource(src);
    }

    protected void processInputMethodEvent(InputMethodEvent e) {
        super.processInputMethodEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processInputMethodEvent(e);
        e.setSource(src);
    }

    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processKeyEvent(e);
        e.setSource(src);
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processMouseEvent(e);
        e.setSource(src);
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processMouseMotionEvent(e);
        e.setSource(src);
    }

    protected void processMouseWheelEvent(MouseWheelEvent e) {
        super.processMouseWheelEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processMouseWheelEvent(e);
        e.setSource(src);
    }

    private final class InternalCanvas3D
    extends Canvas3D
    implements AutoOffScreenCanvas3D {
        private ReentrantLock imageAccessLock;
        private Condition imageCopyCondition;
        private Condition imageResizeCondition;
        private boolean isImageCopied;
        private boolean isRendererLocked;
        private BufferedImage renderImage;
        private int[] paintIntBuffer;
        private int[] renderIntBuffer;
        private Runnable repainter;
        private boolean addNotifyFlag;
        private static final int LIMIT = 200000000;

        private InternalCanvas3D(GraphicsConfiguration graphicsConfiguration) {
            super(graphicsConfiguration, true);
            this.imageAccessLock = null;
            this.imageCopyCondition = null;
            this.imageResizeCondition = null;
            this.isImageCopied = false;
            this.isRendererLocked = false;
            this.renderImage = null;
            this.paintIntBuffer = null;
            this.renderIntBuffer = null;
            this.repainter = null;
            this.addNotifyFlag = false;
            this.imageAccessLock = new ReentrantLock();
            this.imageCopyCondition = this.imageAccessLock.newCondition();
            this.imageResizeCondition = this.imageAccessLock.newCondition();
            this.repainter = new Repainter();
        }

        private void createOffScreenBuffers(Rectangle screenRect, int width, int height) {
            this.stopRenderer();
            int screenWidth = (int)screenRect.getWidth();
            int screenHeight = (int)screenRect.getHeight();
            Screen3D screen3D = this.getScreen3D();
            screen3D.setSize(screenWidth, screenHeight);
            screen3D.setPhysicalScreenWidth((double)screenWidth * METERS_PER_PIXEL);
            screen3D.setPhysicalScreenHeight((double)screenHeight * METERS_PER_PIXEL);
            if (this.renderImage != null) {
                this.renderImage.flush();
            }
            if (JCanvas3DOBAbstract.this.paintImage != null) {
                JCanvas3DOBAbstract.this.paintImage.flush();
            }
            this.renderImage = new BufferedImage(width, height, 2);
            ImageComponent2D image = new ImageComponent2D(2, this.renderImage, true, true);
            image.setCapability(2);
            image.setCapability(3);
            JCanvas3DOBAbstract.this.paintImage = new BufferedImage(width, height, 2);
            this.paintIntBuffer = ((DataBufferInt)JCanvas3DOBAbstract.this.paintImage.getRaster().getDataBuffer()).getData();
            this.renderIntBuffer = ((DataBufferInt)this.renderImage.getRaster().getDataBuffer()).getData();
            JCanvas3DOBAbstract.this.imageWidth = width;
            JCanvas3DOBAbstract.this.imageHeight = height;
            JCanvas3DOBAbstract.this.offScreenBufferCreated();
            try {
                this.imageAccessLock.lock();
                while (this.isRendererLocked) {
                    this.isImageCopied = true;
                    this.imageCopyCondition.signal();
                    try {
                        this.imageResizeCondition.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.waitForOffScreenRendering();
                try {
                    this.setOffScreenBuffer(image);
                }
                catch (RestrictedAccessException e) {
                    this.createOffScreenBuffers(screenRect, width, height);
                    System.out.println("Repeat : createOffScreenBuffer(screenRect, width, height) !!");
                }
            }
            finally {
                this.imageAccessLock.unlock();
            }
            this.startRenderer();
        }

        public void addNotify() {
            if (!this.addNotifyFlag) {
                throw new UnsupportedOperationException("CHANGE ME");
            }
            this.addNotifyFlag = false;
            super.addNotify();
        }

        public Container getParent() {
            return JCanvas3DOBAbstract.this.getParent();
        }

        public void postSwap() {
            if (this.isRendererRunning()) {
                try {
                    this.imageAccessLock.lock();
                    this.isImageCopied = false;
                    SwingUtilities.invokeLater(this.repainter);
                    while (!this.isImageCopied) {
                        this.isRendererLocked = true;
                        try {
                            this.imageCopyCondition.awaitNanos(200000000L);
                            this.isImageCopied = true;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    this.isRendererLocked = false;
                    this.imageResizeCondition.signal();
                }
                finally {
                    this.imageAccessLock.unlock();
                }
            }
        }

        protected void processComponentEvent(ComponentEvent e) {
            super.processComponentEvent(e);
        }

        protected void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
        }

        protected void processInputMethodEvent(InputMethodEvent e) {
            super.processInputMethodEvent(e);
        }

        protected void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
        }

        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
        }

        protected void processMouseMotionEvent(MouseEvent e) {
            super.processMouseMotionEvent(e);
        }

        protected void processMouseWheelEvent(MouseWheelEvent e) {
            super.processMouseWheelEvent(e);
        }

        private class Repainter
        implements Runnable {
            private Repainter() {
            }

            public void run() {
                try {
                    InternalCanvas3D.this.imageAccessLock.lock();
                    System.arraycopy(InternalCanvas3D.this.renderIntBuffer, 0, InternalCanvas3D.this.paintIntBuffer, 0, InternalCanvas3D.this.renderIntBuffer.length);
                    InternalCanvas3D.this.isImageCopied = true;
                    InternalCanvas3D.this.imageCopyCondition.signal();
                }
                finally {
                    InternalCanvas3D.this.imageAccessLock.unlock();
                }
                JCanvas3DOBAbstract.this.offScreenBufferCopied();
                JCanvas3DOBAbstract.this.repaint();
            }
        }
    }
}

