/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import java.util.Vector;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import org.jdesktop.j3d.loaders.vrml97.impl.BaseNode;
import org.jdesktop.j3d.loaders.vrml97.impl.Browser;
import org.jdesktop.j3d.loaders.vrml97.impl.DirectionalLight;
import org.jdesktop.j3d.loaders.vrml97.impl.Loader;
import org.jdesktop.j3d.loaders.vrml97.impl.MFNode;
import org.jdesktop.j3d.loaders.vrml97.impl.NonSharedNode;
import org.jdesktop.j3d.loaders.vrml97.impl.SFInt32;

public class Switch
extends NonSharedNode {
    MFNode choice;
    SFInt32 whichChoice;
    javax.media.j3d.Switch impl;

    public Switch(Loader loader) {
        super(loader);
        this.choice = new MFNode();
        this.whichChoice = new SFInt32(-1);
        this.initFields();
    }

    Switch(Loader loader, MFNode choice, SFInt32 whichChoice) {
        super(loader);
        this.choice = choice;
        this.whichChoice = whichChoice;
        this.initFields();
    }

    void initImpl() {
        if (this.loader.debug) {
            System.out.println("Switch.initImpl() called");
        }
        this.impl = new javax.media.j3d.Switch();
        this.impl.setCapability(17);
        this.impl.setCapability(18);
        this.impl.setCapability(12);
        this.impl.setCapability(13);
        this.impl.setCapability(14);
        this.impl.setUserData(new Vector());
        this.replaceChoices();
        this.setWhichChild();
        if (this.loader.debug) {
            System.out.println("Switch " + this.toStringId() + " impl is " + this.impl);
        }
        this.implNode = this.impl;
        this.implReady = true;
    }

    void setWhichChild() {
        if (Browser.debug) {
            System.out.println("Switch: setting " + this.whichChoice.value);
        }
        if (this.whichChoice.value < 0 || this.whichChoice.value > this.impl.numChildren()) {
            this.impl.setWhichChild(-1);
        } else {
            this.impl.setWhichChild(this.whichChoice.value);
        }
    }

    void replaceChoices() {
        int i;
        int numChildren = this.impl.numChildren();
        if (numChildren != 0) {
            i = 0;
            while (i < numChildren) {
                this.impl.removeChild(0);
                ++i;
            }
        }
        i = 0;
        while (i < this.choice.nodes.length) {
            BaseNode child = this.choice.nodes[i];
            child.updateParent((Node)this.impl);
            Node implNode = child.getImplNode();
            if (this.loader.debug) {
                System.out.println(String.valueOf(this.toStringId()) + ":  index = " + i + " child node type is " + child.getType() + " " + child.toStringId() + " gets implNoded to " + implNode);
            }
            if (implNode != null) {
                if (implNode.getParent() == null) {
                    this.impl.addChild(implNode);
                } else {
                    this.impl.addChild(implNode.cloneNode(true));
                }
                if (child instanceof DirectionalLight) {
                    DirectionalLight dirLight = (DirectionalLight)child;
                    dirLight.setScope((Group)this.impl);
                }
            }
            ++i;
        }
    }

    public int getNumTris() {
        int numTris = 0;
        if (this.choice != null && this.choice.nodes != null && this.choice.nodes.length > 0) {
            numTris += this.choice.nodes[0].getNumTris();
        }
        return numTris;
    }

    public void notifyMethod(String eventInName, double time) {
        if (eventInName.equals("choice")) {
            this.replaceChoices();
        } else if (eventInName.equals("whichChoice")) {
            this.setWhichChild();
        }
    }

    public Object clone() {
        return new Switch(this.loader, (MFNode)this.choice.clone(), (SFInt32)this.whichChoice.clone());
    }

    public String getType() {
        return "Switch";
    }

    void initFields() {
        this.choice.init(this, this.FieldSpec, 3, "choice");
        this.whichChoice.init(this, this.FieldSpec, 3, "whichChoice");
    }
}

