/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import com.sun.j3d.utils.geometry.Text2D;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import org.jdesktop.j3d.loaders.vrml97.impl.FontStyle;
import org.jdesktop.j3d.loaders.vrml97.impl.Geometry;
import org.jdesktop.j3d.loaders.vrml97.impl.Loader;
import org.jdesktop.j3d.loaders.vrml97.impl.MFFloat;
import org.jdesktop.j3d.loaders.vrml97.impl.MFString;
import org.jdesktop.j3d.loaders.vrml97.impl.SFFloat;
import org.jdesktop.j3d.loaders.vrml97.impl.SFNode;

public class Text
extends Geometry {
    MFString string;
    SFNode fontStyle;
    MFFloat length;
    SFFloat maxExtent;
    static String vrmlSerif = "SERIF";
    static String vrmlSans = "SANS";
    static String vrmlFixed = "TYPEWRITER";
    static String j3dSerif = "Serif";
    static String j3dSans = "Sans";
    static String j3dFixed = "Courier";
    static String vrmlPlain = "PLAIN";
    static String vrmlBold = "BOLD";
    static String vrmlItalic = "ITALIC";
    static String vrmlBoldItalic = "BOLDITALIC";
    static final int RASTER_SIZE = 24;
    TransformGroup impl = null;

    public Text(Loader loader) {
        super(loader);
        this.string = new MFString();
        this.fontStyle = new SFNode();
        this.length = new MFFloat();
        this.maxExtent = new SFFloat(0.0f);
        this.initFields();
    }

    public Text(Loader loader, MFString string, SFNode fontStyle, MFFloat length, SFFloat maxExtent) {
        super(loader);
        this.string = string;
        this.fontStyle = fontStyle;
        this.length = length;
        this.maxExtent = maxExtent;
        this.initFields();
    }

    Node createText2D(Appearance app) {
        if (this.loader.debug) {
            System.out.println("Text.createText2D() called");
        }
        if (this.string.strings != null && this.string.strings.length > 0) {
            Material mat;
            if (this.loader.debug) {
                System.out.println("creating Text2D object");
            }
            FontStyle fs = null;
            fs = this.fontStyle.node != null && this.fontStyle.node instanceof FontStyle ? (FontStyle)this.fontStyle.node : new FontStyle(this.loader);
            Color3f fontColor = new Color3f(1.0f, 1.0f, 1.0f);
            if (app != null && (mat = app.getMaterial()) != null) {
                mat.getDiffuseColor(fontColor);
            }
            String fontName = j3dSerif;
            if (fs.family.strings.length > 0) {
                boolean found = false;
                int i = 0;
                while (i < fs.family.strings.length && !found) {
                    if (vrmlSerif.equals(fs.family.strings[i])) {
                        fontName = j3dSerif;
                        found = true;
                    } else if (vrmlSans.equals(fs.family.strings[i])) {
                        fontName = j3dSans;
                        found = true;
                    } else if (vrmlFixed.equals(fs.family.strings[i])) {
                        fontName = j3dFixed;
                        found = true;
                    }
                    ++i;
                }
            }
            int fontStyleId = 0;
            if (fs.style.string != null) {
                if (vrmlPlain.equals(fs.style.string)) {
                    fontStyleId = 0;
                } else if (vrmlBold.equals(fs.style.string)) {
                    fontStyleId = 1;
                } else if (vrmlItalic.equals(fs.style.string)) {
                    fontStyleId = 2;
                } else if (vrmlBoldItalic.equals(fs.style.string)) {
                    fontStyleId = 3;
                }
            }
            this.impl = new TransformGroup();
            Text2D text = new Text2D(this.string.strings[0], fontColor, fontName, 24, fontStyleId);
            this.impl.addChild((Node)text);
            Transform3D textXform = new Transform3D();
            float fontSize = 24.0f * text.getRectangleScaleFactor();
            float scale = fs.size.value / fontSize;
            textXform.setScale((double)scale);
            this.impl.setTransform(textXform);
            this.implNode = this.impl;
        }
        return this.impl;
    }

    public javax.media.j3d.Geometry getImplGeom() {
        return null;
    }

    public boolean haveTexture() {
        return false;
    }

    public int getNumTris() {
        return 0;
    }

    public BoundingBox getBoundingBox() {
        return null;
    }

    public String getType() {
        return "Text";
    }

    public Object clone() {
        return new Text(this.loader, (MFString)this.string.clone(), (SFNode)this.fontStyle.clone(), (MFFloat)this.length.clone(), (SFFloat)this.maxExtent.clone());
    }

    public void notifyMethod(String eventInName, double time) {
        System.out.println("Text: unimplemented event " + eventInName);
    }

    void initFields() {
        this.string.init(this, this.FieldSpec, 3, "string");
        this.fontStyle.init(this, this.FieldSpec, 3, "fontStyle");
        this.length.init(this, this.FieldSpec, 3, "length");
        this.maxExtent.init(this, this.FieldSpec, 3, "maxExtent");
    }
}

